//
// Copyright (c) 1998-2001 B2C2, Inc.  All Rights Reserved.
//

// ib2c2mpeg2pvrctrl.h

// Note: Contains interfaces IB2C2MPEG2PvrCtrl


#ifndef _IB2C2MPEG2PVRCTRL_H_
#define _IB2C2MPEG2PVRCTRL_H_

///////////////////////////////////////////////////////////////////////////////
 //
// definitions
//

enum E_PVR_OPTION
{
	PVR_AUTO_DELETE_RECORD_FILE	= 0,
	PVR_AUTO_RECORD_WITH_PLAY	= 1,
};

enum E_PVR_CALLBACK_STATE
{
	PVR_PLAY_FILE_EOF			= 0,
	PVR_RECORD_FILE_ERROR		= 1,
};

#define	PVR_PIDS_MAX	6

///////////////////////////////////////////////////////////////////////////////
//
// IB2C2MPEG2TimeshiftCtrl
//

#if defined __linux__	// Class implementation for Linux

class IB2C2MPEG2TimeshiftCtrl
{
protected: // Data

	CAVSrcFilter * m_pFilter;

public:	// Constructor
	IB2C2MPEG2TimeshiftCtrl (CAVSrcFilter *);

#else 					// COM implementation for Windows

#ifdef __cplusplus
extern "C" {
#endif

// Interface: IB2C2MPEG2TimeshiftCtrl

//DECLARE_INTERFACE_(IB2C2MPEG2TimeshiftCtrl, IB2C2MPEG2PvrCtrl) {
DECLARE_INTERFACE_(IB2C2MPEG2TimeshiftCtrl, IUnknown) {

#endif //defined __linux__

	STDMETHOD(SetFilename) (THIS_
				WCHAR* pwsRecFileName
			 ) PURE;

	STDMETHOD (GetFilename) (THIS_
				WCHAR* pwsRecFileName
			 ) PURE;

	STDMETHOD (StartRecord) (THIS_
				void
			 ) PURE;

	STDMETHOD (StopRecord) (THIS_
				void
			 ) PURE;

	STDMETHOD (Enable) (THIS_
				void
			 ) PURE;

	STDMETHOD (Disable) (THIS_
				void
			 ) PURE;

	STDMETHOD (SetOption) (THIS_
				E_PVR_OPTION eCommand, PVOID pvData
			 ) PURE;

	STDMETHOD (GetOption) (THIS_
				E_PVR_OPTION eCommand, PVOID pvData
			 ) PURE;

	STDMETHOD (SetFilePosition) (THIS_
				 __int64 i64PositionData
			 ) PURE;

	STDMETHOD (GetFileSize) (THIS_
				 __int64* pi64FileSize
			 ) PURE;

	STDMETHOD (GetFilePosition) (THIS_
				 __int64* pi64FilePosition
			 ) PURE;

	STDMETHOD (SetCallback) (THIS_ 
				PVOID pvCallBack
			) PURE;

};


#if defined WIN32

#ifdef __cplusplus
}
#endif

#endif //defined WIN32

#endif // _IB2C2MPEG2PVRCTRL_H_
