//
// Copyright (c) 1998-2001 B2C2, Inc.  All Rights Reserved.
//

// ib2c2mpeg2pvrctrl.h

// Note: Contains interfaces IB2C2MPEG2PvrCtrl


#ifndef _IB2C2MPEG2MULTICASTCTRL_H_
#define _IB2C2MPEG2MULTICASTCTRL_H_

///////////////////////////////////////////////////////////////////////////////
 //
// definitions
//


///////////////////////////////////////////////////////////////////////////////
//
// IB2C2MPEG2TimeshiftCtrl
//

#if defined __linux__	// Class implementation for Linux

class IB2C2MPEG2MulticastCtrl
{
protected: // Data

	CAVSrcFilter * m_pFilter;

public:	// Constructor
	IB2C2MPEG2MulticastCtrl (CAVSrcFilter *);

#else 					// COM implementation for Windows

#ifdef __cplusplus
extern "C" {
#endif

// Interface: IB2C2MPEG2TimeshiftCtrl

DECLARE_INTERFACE_(IB2C2MPEG2MulticastCtrl, IUnknown) {

#endif //defined __linux__

	STDMETHOD (Enable) (THIS_ 
				void
			) PURE;

	STDMETHOD (Disable) (THIS_
				void
			 ) PURE;

	STDMETHOD(StartMulticast) (THIS_
				char* szMulticastAddress, WORD wMulticastPort, long lPIDCount, long* lPIDArray
			 ) PURE;

	STDMETHOD (StopMulticast) (THIS_
				char* szMulticastAddress, WORD wMulticastPort
			 ) PURE;

	STDMETHOD (SetNetworkInterface) (THIS_
				char* szNetworkInterfaceAddress
			 ) PURE;

	STDMETHOD (GetNetworkInterface) (THIS_
				char* szNetworkInterfaceAddress
			 ) PURE;
};


#if defined WIN32

#ifdef __cplusplus
}
#endif

#endif //defined WIN32

#endif // _IB2C2MPEG2MULTICASTCTRL_H_
