@echo off

rem B2Settuner sample script for Terrestrial ATSC tuner

rem	 Required Arguments:
rem	 -a    Adapter name; e.g. eth1 (Linux only)
rem	 -i    Tuner type; valid values are:
rem	       c (cable), s (satellite), t (terrestrial DVB),
rem	       a (terrestrial ATSC),
rem	       One of the following must be specified for (c, s, t, a):
rem	 -f    Frequency (Transponder) in MHz (c, s, t, a)
rem	 -fk   Frequency (Transponder) in kHz (c, s, t, a)
rem	 -s    Symbol Rate in Ks/s (c, s); e.g. 6111
rem	 -m    Modulation in QAM (c); valid values are:
rem	       4, 16, 32, 64, 128, 256
rem	 -l    LNB Frequency in MHz (s); note: must be less than Transponder
rem	       Frequency specified with -f
rem	 -e    FEC (s); valid values are:
rem	       1/2, 2/3, 3/4, 5/6, 7/8, auto
rem	 -o    Polarity (s); valid values are: h (horizontal), v (vertical)
rem	 -k    LNB Selection in KHz(s); valid values are: 0, 22, 33, 44
rem	 -d    Diseqc (s); valid values are:
rem	       n (none), a, b, a/a, a/b, b/a, b/b
rem	 -g    Guard interval (t); valid values are: 1/4, 1/8, 1/16, 1/32
rem	 -b    Bandwidth in Mhz (t); valid values are: 6, 7, 8 
rem	 -pd   IP PID as integer or hex. (c, s); e.g. 164, 0xa4 or 0XA4.
rem	       For each IP PID, specify a separate -pd option;
rem	       e.g. -pd 17 -pd 18, etc.  Maximum # of PIDs supported: 32

rem	 Optional Arguments:
rem	 -st   Skip Tuning
rem	 -ma   MAC address as 6 pairs of hex digits preceded with 0x;
rem	       e.g. 0x01005e010500
rem	 -t    Time duration in seconds to pause while data is received
rem	 -r    Times to repeat test if not in lock
rem	 -pia  Add IP PID (same as -pd)
rem	 -pid  Delete IP PID given as next argument in decimal or hex(0x)
rem	 -pil  List IP PIDs
rem	 -pta  Add TS PID given as next argument in decimal or hex (0x)
rem	 -ptd  Delete TS PID given as next argument in decimal or hex(0x)
rem	 -ptl  List TS PIDs
rem	 -paa  Add Audio PID given as next argument in decimal or hex(0x)
rem	 -pad  Delete Audio PID; PID must not be given as argument
rem	 -pva  Add Video PID given as next argument in decimal or hex(0x)
rem	 -pvd  Delete Video PID; PID must not be given as argument
rem	 -pal  List Audio/Video PIDs
rem	 -ums  Set unicast MAC address
rem	 -uml  Lists unicast MAC address
rem	 -umr  Restores unicast MAC address from device
rem	 -mms  Set multicast MAC address
rem	 -mml  Lists multicast MAC address
rem	 -mmd  Deletes multicast MAC address
rem	 -stid Set datagram packet table ID; valid values are: 3E, 3F
rem	 -gtid Get datagram packet table ID
rem	 -kpa  Add key for given PID and TSC field values;
rem	         PID can be given as decimal or hex (0x) value;
rem	 	    Possible TSC values are: 01, 10 (even), 11 (odd);
rem	         Key value is given as 8 pairs of hex digits;
rem	 	  e.g. 0x1234 10 1122334455667788
rem	 -kpd  Delete key for given PID and TSC values;
rem	         PID can be given as decimal or hex (0x) value;
rem	 	    Valid TSC values are: 01, 10 (even), 11 (odd);
rem	 	  e.g. 0x1234 11
rem	 -kas  Add key for given PID and ANY TSC field value;
rem	         PID can be given as decimal or hex (0x) value;
rem	 	    Key value is given as 8 pairs of hex digits;
rem	 	  e.g. 0x1234 1122334455667788
rem	 -kad  Delete key for PID and ANY TSC values
rem	 -kgs  Set global key as 8 pairs of hex digits; 
rem	       e.g. 1122334455667788
rem	 -kgd  Delete global key
rem	 -kp   Purge all existing keys
rem	 -kl   Lists all existing keys
rem	 -h    Help\n";

@echo on
.\b2settuner.exe -a B2C2 -i a -f 725
@echo off

pause
